"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_2 = require("@use-gesture/react");
const classnames_1 = __importDefault(require("classnames"));
const react_virtual_1 = require("react-virtual");
const element_1 = require("../../../common/utils/element");
const commit_1 = require("../../../../git/commit");
const index_module_scss_1 = __importDefault(require("./index.module.scss"));
function escapeSpecialChars(jsonString) {
    return jsonString
        .replace(/\\/g, '\\\\') // Replace backslashes
        .replace(/"/g, '\\"') // Replace double quotes
        .replace(/\t/g, '\\t') // Replace tabs
        .replace(/\r?\n/g, '\\n') // Replace newlines
        .replace(/\r/g, '\\r'); // Replace carriage returns
}
const INDEX_PLACEHOLDER = -1;
const SCROLL_BAR_WIDTH = 10;
const PickableListRender = (props, scrollContainerRef) => {
    const { list, keyLength, locationIndex, itemPipe, itemRender, onPick, } = props;
    const dragContainerRef = (0, react_1.useRef)(null);
    const { virtualItems, totalSize, scrollToIndex } = (0, react_virtual_1.useVirtual)({
        size: list.length,
        parentRef: scrollContainerRef,
        overscan: 10,
    });
    const [pickedItems, setPickedItems] = (0, react_1.useState)({});
    const [containerRect, setContainerRect] = (0, react_1.useState)();
    const [itemYs, setItemYs] = (0, react_1.useState)([]);
    const [dragStartIndex, setDragStartIndex] = (0, react_1.useState)(INDEX_PLACEHOLDER);
    (0, react_1.useEffect)(() => {
        if (typeof locationIndex !== "number") {
            return;
        }
        scrollToIndex(locationIndex || 0, { align: "center" });
    }, [scrollToIndex, locationIndex]);
    const dragBind = (0, react_2.useDrag)(({ type, xy, target, ctrlKey }) => {
        var _a, _b;
        if (!virtualItems.length) {
            return;
        }
        const [x, y] = xy;
        const existedItems = ctrlKey ? pickedItems : {};
        const firstItemIndex = virtualItems[0].index;
        if (type === "pointerdown") {
            const scrollContainerEl = scrollContainerRef.current;
            const isPointerOnButton = !!target.closest("[data-button]");
            if (isPointerOnButton) {
                return;
            }
            const isPointerOnScrollBar = scrollContainerEl.getBoundingClientRect().width - x <=
                SCROLL_BAR_WIDTH;
            if ((0, element_1.checkScrollBarVisible)(scrollContainerEl) &&
                isPointerOnScrollBar) {
                return;
            }
            const realTimeContainerRect = (_a = dragContainerRef.current) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect();
            const realTimeItemYs = Array.from(((_b = dragContainerRef.current) === null || _b === void 0 ? void 0 : _b.children) || []).map((element) => element.getBoundingClientRect().y);
            const dragStartIndex = firstItemIndex + sortedIndex(realTimeItemYs, y) - 1;
            setContainerRect(realTimeContainerRect);
            setItemYs(realTimeItemYs);
            setDragStartIndex(dragStartIndex);
            const id = list[dragStartIndex].slice(0, keyLength);
            setPickedItems(Object.assign(Object.assign({}, existedItems), { [id]: dragStartIndex }));
            return;
        }
        if (type === "pointerup") {
            if (dragStartIndex === INDEX_PLACEHOLDER) {
                return;
            }
            setDragStartIndex(INDEX_PLACEHOLDER);
            if (onPick) {
                const pickedIds = Object.keys(pickedItems).sort((id1, id2) => pickedItems[id1] - pickedItems[id2]);
                onPick(pickedIds, pickedIds.map((id) => itemPipe(list[pickedItems[id]])));
            }
            return;
        }
        if (containerRect &&
            x > containerRect.x &&
            x < containerRect.x + containerRect.width &&
            y > containerRect.y &&
            y < containerRect.y + containerRect.height) {
            if (dragStartIndex === INDEX_PLACEHOLDER) {
                return;
            }
            const currentIndex = firstItemIndex + sortedIndex(itemYs, y) - 1;
            const currentItems = Object.assign({}, existedItems);
            for (let index = Math.min(dragStartIndex, currentIndex); index <= Math.max(dragStartIndex, currentIndex); index++) {
                const id = list[index].slice(0, keyLength);
                if (!Object.prototype.hasOwnProperty.call(currentItems, id)) {
                    currentItems[id] = index;
                }
            }
            setPickedItems(currentItems);
        }
    });
    const container = (0, jsx_runtime_1.jsx)("div", Object.assign({}, dragBind(), { ref: scrollContainerRef, style: { overflow: "auto" }, className: index_module_scss_1.default.container }, { children: (0, jsx_runtime_1.jsx)("div", Object.assign({ ref: dragContainerRef, style: {
                height: `${totalSize}px`,
                width: "100%",
                position: "relative",
            } }, { children: list.length ? virtualItems.map((virtualRow) => {
                var _a;
                if (list[virtualRow.index]) {
                    const commit = itemPipe(list[virtualRow.index]);
                    const message = escapeSpecialChars(commit[commit_1.CommitIndex.MESSAGE]);
                    const hash = commit[commit_1.CommitIndex.HASH];
                    const isMergeCommit = ((_a = commit[commit_1.CommitIndex.PARENTS]) === null || _a === void 0 ? void 0 : _a.length) > 1;
                    return ((0, jsx_runtime_1.jsx)("div", Object.assign({ ref: virtualRow.measureRef, className: (0, classnames_1.default)(index_module_scss_1.default.item, {
                            [index_module_scss_1.default.picked]: list[virtualRow.index] &&
                                Object.prototype.hasOwnProperty.call(pickedItems, list[virtualRow.index].slice(0, keyLength)),
                            [index_module_scss_1.default.located]: virtualRow.index === locationIndex,
                            [index_module_scss_1.default.merged]: isMergeCommit,
                        }), style: {
                            position: "absolute",
                            top: 0,
                            left: 0,
                            width: "100%",
                            height: "22px",
                            transform: `translateY(${virtualRow.start}px)`,
                        }, "data-vscode-context": `{"message":"${message}","hash":"${hash}"}` }, { children: list[virtualRow.index] &&
                            itemRender(commit) }), hash));
                }
                else {
                    return (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {});
                }
            }) : (0, jsx_runtime_1.jsx)(jsx_runtime_1.Fragment, {}) })) }));
    return container;
};
const PickableList = (0, react_1.forwardRef)(PickableListRender);
function sortedIndex(array, value) {
    let low = 0;
    let high = array !== null ? array.length : 0;
    while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (array[mid] < value) {
            low = mid + 1;
        }
        else {
            high = mid;
        }
    }
    return low;
}
exports.default = PickableList;
//# sourceMappingURL=index.js.map